/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.chemical.item.ItemStackMekanismGasHandler;
import mekanism.common.capabilities.chemical.variable.RateLimitChemicalTank;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RateLimitGasHandler
extends ItemStackMekanismGasHandler {
    private final IGasTank tank;

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity) {
        return RateLimitGasHandler.create(rate, capacity, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue, null);
    }

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid) {
        return RateLimitGasHandler.create(rate, capacity, canExtract, canInsert, isValid, null);
    }

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid, @Nullable ChemicalAttributeValidator attributeValidator) {
        Objects.requireNonNull(rate, "Rate supplier cannot be null");
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(isValid, "Gas validity check cannot be null");
        return new RateLimitGasHandler(listener -> new RateLimitChemicalTank.RateLimitGasTank(rate, capacity, canExtract, canInsert, isValid, attributeValidator, (IContentsListener)listener));
    }

    private RateLimitGasHandler(Function<IContentsListener, IGasTank> tankProvider) {
        this.tank = tankProvider.apply(this);
    }

    @Override
    protected List<IGasTank> getInitialTanks() {
        return Collections.singletonList(this.tank);
    }
}

